﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace Malefiz
{
    class Barrikade : Spielobjekt
    {
        private int barrikadennummer;

        /// <summary>
        /// In dieser Eigenschaft wird die Nummer dieser Barrikade gespeichert. 
        /// 0: Barrikade 1 ... 10: Barrikade 11
        /// </summary>
        public int Barrikadennummer
        {
            get { return barrikadennummer; }
        }



        //Konstruktor

        /// <summary>
        /// Erstellt eine neue Barrikade. Jeder Barrikade wird automatisch das Porträt einer Barrikade 
        /// in die Eigenschaft Porträt gespeichert. Jede Barrikade wird automatisch auf ihre Ausgangsposition 
        /// im Spielbrett gesetzt, indem ihr die richtige Feldposition zugewiesen wird. 
        /// Die Barrikadennummer kann anschließend nicht mehr verändert werden.
        /// </summary>
        /// <param name="barrikadennummer">Nummer der Barrikade: 
        /// 0: Barrikade 1 ... 10: Barrikade 11</param>
        public Barrikade(int _barrikadennummer) : base()
        {
            barrikadennummer = _barrikadennummer;

            if (_barrikadennummer == 0)
            { X = 0; Y = 2; }
            if (_barrikadennummer == 1)
            { X = 4; Y = 2; }
            if (_barrikadennummer == 2)
            { X = 8; Y = 2; }
            if (_barrikadennummer == 3)
            { X = 12; Y = 2; }
            if (_barrikadennummer == 4)
            { X = 16; Y = 2; }
            if (_barrikadennummer == 5)
            { X = 6; Y = 6; }
            if (_barrikadennummer == 6)
            { X = 10; Y = 6; }
            if (_barrikadennummer == 7)
            { X = 8; Y = 8; }
            if (_barrikadennummer == 8)
            { X = 8; Y = 9; }
            if (_barrikadennummer == 9)
            { X = 8; Y = 10; }
            if (_barrikadennummer == 10)
            { X = 8; Y = 12; }

            Porträt = pictures.Barrikade;
        }
    }
}